/*
 * Decompiled with CFR 0.152.
 */
package uni.mt.tts;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.speech.tts.TextToSpeech;
import android.speech.tts.UtteranceProgressListener;
import android.widget.Toast;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.bridge.JSCallback;
import io.dcloud.feature.uniapp.annotation.UniJSMethod;
import io.dcloud.feature.uniapp.bridge.UniJSCallback;
import io.dcloud.feature.uniapp.common.UniModule;
import java.util.List;
import java.util.Locale;

public class SpeechTTS
extends UniModule {
    String TAG = "SpeechTTS";
    private TextToSpeech mSpeech;
    private Boolean isInited;
    private JSCallback jsHandler;
    private JSCallback onStartCallback = new JSCallback(){

        public void invoke(Object o) {
        }

        public void invokeAndKeepAlive(Object o) {
        }
    };
    private JSCallback onDoneCallback = new JSCallback(){

        public void invoke(Object o) {
        }

        public void invokeAndKeepAlive(Object o) {
        }
    };
    private JSCallback onErrorCallback = new JSCallback(){

        public void invoke(Object o) {
        }

        public void invokeAndKeepAlive(Object o) {
        }
    };

    @UniJSMethod(uiThread=true)
    public void toast(String text) {
        Toast.makeText((Context)this.mUniSDKInstance.getContext(), (CharSequence)text, (int)0).show();
    }

    @UniJSMethod(uiThread=true)
    public void init(UniJSCallback callback, String engine) {
        this.jsHandler = callback;
        this.mSpeech = new TextToSpeech(this.mUniSDKInstance.getContext(), new TextToSpeech.OnInitListener(){

            public void onInit(int status) {
                SpeechTTS.this.isInited = true;
                SpeechTTS.this.jsHandler.invoke((Object)0);
            }
        }, engine);
        this.mSpeech.setOnUtteranceProgressListener(new UtteranceProgressListener(){

            public void onStart(String utteranceId) {
                SpeechTTS.this.onStartCallback.invokeAndKeepAlive((Object)utteranceId);
            }

            public void onDone(String utteranceId) {
                SpeechTTS.this.onDoneCallback.invokeAndKeepAlive((Object)utteranceId);
            }

            public void onError(String utteranceId) {
                SpeechTTS.this.onErrorCallback.invokeAndKeepAlive((Object)utteranceId);
            }
        });
        this.mSpeech.setLanguage(Locale.CHINESE);
    }

    @UniJSMethod(uiThread=true)
    public void onStart(JSCallback jsCallback) {
        this.onStartCallback = jsCallback;
    }

    @UniJSMethod(uiThread=true)
    public void onDone(JSCallback jsCallback) {
        this.onDoneCallback = jsCallback;
    }

    @UniJSMethod(uiThread=true)
    public void onError(JSCallback jsCallback) {
        this.onErrorCallback = jsCallback;
    }

    @UniJSMethod(uiThread=false)
    public int speak(JSONObject object) {
        int queueType;
        String text = this.GetValue(object, "text", "");
        String queue = this.GetValue(object, "queue", "flush");
        String id = this.GetValue(object, "id", String.valueOf(Math.round(Math.random() * 1000.0)));
        int n = queueType = queue.toUpperCase().equals("FLUSH") ? 0 : 1;
        if (Build.VERSION.SDK_INT >= 21) {
            return this.mSpeech.speak((CharSequence)text, queueType, null, id);
        }
        return this.mSpeech.speak(text, queueType, null);
    }

    @UniJSMethod(uiThread=true)
    public void getInstallTTS(JSCallback callback) {
        List engineList = this.mSpeech.getEngines();
        callback.invoke((Object)engineList);
    }

    @UniJSMethod(uiThread=false)
    public int setEngine(String engine) {
        return this.mSpeech.setEngineByPackageName(engine);
    }

    @UniJSMethod(uiThread=false)
    public void setPitch(int value) {
        if (value > 100) {
            value = 100;
        }
        if (value < 0) {
            value = 0;
        }
        float tempValue = (float)((double)(value * 2) * 0.01);
        this.mSpeech.setPitch(tempValue);
    }

    @UniJSMethod(uiThread=false)
    public void setSpeed(int value) {
        if (value > 100) {
            value = 100;
        }
        if (value < 0) {
            value = 0;
        }
        float tempValue = (float)((double)value * 1.5 * 0.01);
        this.mSpeech.setSpeechRate(tempValue);
    }

    @UniJSMethod(uiThread=false)
    public Boolean isSpeeking() {
        return this.mSpeech.isSpeaking();
    }

    @UniJSMethod(uiThread=false)
    public int setLanguage(String lang) {
        int res = 1;
        res = lang.equals("ENGLISH") ? this.mSpeech.setLanguage(Locale.ENGLISH) : this.mSpeech.setLanguage(Locale.CHINESE);
        return res;
    }

    @UniJSMethod(uiThread=false)
    public void stop() {
        this.mSpeech.stop();
    }

    @UniJSMethod(uiThread=true)
    public void destroy() {
        if (this.mSpeech == null) {
            return;
        }
        this.mSpeech.stop();
        this.mSpeech.shutdown();
        this.mSpeech = null;
    }

    @UniJSMethod(uiThread=true)
    public void openSettings() {
        this.mUniSDKInstance.getContext().startActivity(new Intent("com.android.settings.TTS_SETTINGS"));
    }

    public int GetValue(JSONObject object, String key, int defaultValue) {
        object = object == null ? new JSONObject() : object;
        return object.containsKey((Object)key) ? object.getInteger(key) : defaultValue;
    }

    public String GetValue(JSONObject object, String key, String defaultValue) {
        object = object == null ? new JSONObject() : object;
        return object.containsKey((Object)key) ? object.getString(key) : defaultValue;
    }

    public Boolean GetValue(JSONObject object, String key, Boolean defaultValue) {
        object = object == null ? new JSONObject() : object;
        return object.containsKey((Object)key) ? object.getBoolean(key) : defaultValue;
    }
}

