/*
 * Decompiled with CFR 0.152.
 */
package uni.mt.tts.util;

import android.content.Context;
import android.content.res.AssetManager;
import android.util.Log;
import java.io.IOException;
import java.util.HashMap;
import uni.mt.tts.util.FileUtil;
import uni.mt.tts.util.IOfflineResourceConst;

public class OfflineResource
implements IOfflineResourceConst {
    private AssetManager assets;
    private String destPath;
    private String textFilename;
    private String modelFilename;
    private static HashMap<String, Boolean> mapInitied = new HashMap();

    public OfflineResource(Context context, String voiceType) throws IOException {
        context = context.getApplicationContext();
        this.assets = context.getApplicationContext().getAssets();
        this.destPath = FileUtil.createTmpDir(context);
        this.setOfflineVoiceType(voiceType);
    }

    public String getModelFilename() {
        return this.modelFilename;
    }

    public String getTextFilename() {
        return this.textFilename;
    }

    public void setOfflineVoiceType(String voiceType) throws IOException {
        String model;
        String text = "bd_etts_common_text_txt_all_mand_eng_middle_big_v3.4.2_20190710.dat";
        if ("M".equals(voiceType)) {
            model = "bd_etts_common_speech_m15_mand_eng_high_am-mgc_v3.6.0_20190117.dat";
        } else if ("F".equals(voiceType)) {
            model = "bd_etts_common_speech_f7_mand_eng_high_am-mgc_v3.6.0_20190117.dat";
        } else if ("X".equals(voiceType)) {
            model = "bd_etts_common_speech_yyjw_mand_eng_high_am-mgc_v3.6.0_20190117.dat";
        } else if ("Y".equals(voiceType)) {
            model = "bd_etts_common_speech_as_mand_eng_high_am-mgc_v3.6.0_20190117.dat";
        } else {
            throw new RuntimeException("voice type is not in list");
        }
        this.textFilename = this.copyAssetsFile(text);
        this.modelFilename = this.copyAssetsFile(model);
    }

    private String copyAssetsFile(String sourceFilename) throws IOException {
        String destFilename = this.destPath + "/" + sourceFilename;
        boolean recover = false;
        Boolean existed = mapInitied.get(sourceFilename);
        if (existed == null || !existed.booleanValue()) {
            recover = true;
        }
        FileUtil.copyFromAssets(this.assets, sourceFilename, destFilename, recover);
        Log.i((String)"ContentValues", (String)("\u6587\u4ef6\u590d\u5236\u6210\u529f\uff1a" + destFilename));
        return destFilename;
    }
}

