/*
 * Decompiled with CFR 0.152.
 */
package uni.mt.tts.util;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import androidx.core.content.ContextCompat;
import com.baidu.tts.client.SpeechSynthesizer;
import com.baidu.tts.client.SynthesizerTool;
import com.baidu.tts.client.TtsMode;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeSet;
import org.json.JSONObject;
import uni.mt.tts.control.InitTTSConfig;

public class AutoCheck {
    private static AutoCheck instance;
    private LinkedHashMap<String, Check> checks;
    private static Context context;
    private boolean hasError = false;
    volatile boolean isFinished = false;

    public static AutoCheck getInstance(Context context) {
        if (instance == null || AutoCheck.context != context) {
            instance = new AutoCheck(context);
        }
        return instance;
    }

    public void check(final InitTTSConfig initConfig, final Handler handler) {
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AutoCheck obj = AutoCheck.this.innerCheck(initConfig);
                AutoCheck.this.isFinished = true;
                AutoCheck autoCheck = obj;
                synchronized (autoCheck) {
                    Message msg = handler.obtainMessage(100, (Object)obj);
                    handler.sendMessage(msg);
                }
            }
        });
        t.start();
    }

    private AutoCheck innerCheck(InitTTSConfig config) {
        boolean isOnlineSdk = TtsMode.ONLINE.equals((Object)config.getTtsMode());
        this.checks.put("\u68c0\u67e5\u7533\u8bf7\u7684Android\u6743\u9650", new PermissionCheck(context));
        this.checks.put("\u68c0\u67e54\u4e2aso\u6587\u4ef6\u662f\u5426\u5b58\u5728", new JniCheck(context, isOnlineSdk));
        this.checks.put("\u68c0\u67e5AppId AppKey SecretKey", new AppInfoCheck(config.getAppId(), config.getAppKey(), config.getSecretKey()));
        this.checks.put("\u68c0\u67e5\u5305\u540d", new ApplicationIdCheck(context, config.getAppId()));
        if (!isOnlineSdk) {
            Map<String, String> params = config.getParams();
            String fileKey = SpeechSynthesizer.PARAM_TTS_TEXT_MODEL_FILE;
            this.checks.put("\u68c0\u67e5\u79bb\u7ebf\u8d44TEXT\u6587\u4ef6\u53c2\u6570", new ParamKeyExistCheck(params, fileKey, "SpeechSynthesizer.PARAM_TTS_TEXT_MODEL_FILE\u672a\u8bbe\u7f6e \uff0c"));
            this.checks.put("\u68c0\u67e5\u79bb\u7ebf\u8d44\u6e90TEXT\u6587\u4ef6", new OfflineResourceFileCheck(params.get(fileKey)));
            fileKey = SpeechSynthesizer.PARAM_TTS_SPEECH_MODEL_FILE;
            this.checks.put("\u68c0\u67e5\u79bb\u7ebf\u8d44Speech\u6587\u4ef6\u53c2\u6570", new ParamKeyExistCheck(params, fileKey, "SpeechSynthesizer.PARAM_TTS_SPEECH_MODEL_FILE\u672a\u8bbe\u7f6e \uff0c"));
            this.checks.put("\u68c0\u67e5\u79bb\u7ebf\u8d44\u6e90Speech\u6587\u4ef6", new OfflineResourceFileCheck(params.get(fileKey)));
        }
        for (Map.Entry<String, Check> e : this.checks.entrySet()) {
            Check check = e.getValue();
            check.check();
            if (!check.hasError()) continue;
            break;
        }
        return this;
    }

    public String obtainErrorMessage() {
        PrintConfig config = new PrintConfig();
        return this.formatString(config);
    }

    public String obtainDebugMessage() {
        PrintConfig config = new PrintConfig();
        config.withInfo = true;
        return this.formatString(config);
    }

    public String obtainAllMessage() {
        PrintConfig config = new PrintConfig();
        config.withLog = true;
        config.withInfo = true;
        return this.formatString(config);
    }

    public String formatString(PrintConfig config) {
        StringBuilder sb = new StringBuilder();
        this.hasError = false;
        for (Map.Entry<String, Check> entry : this.checks.entrySet()) {
            Check check = entry.getValue();
            String testName = entry.getKey();
            if (check.hasError()) {
                if (!this.hasError) {
                    this.hasError = true;
                }
                sb.append("\u3010\u9519\u8bef\u3011\u3010").append(testName).append(" \u3011  ").append(check.getErrorMessage()).append("\n");
                if (check.hasFix()) {
                    sb.append("\u3010\u4fee\u590d\u65b9\u6cd5\u3011\u3010").append(testName).append(" \u3011  ").append(check.getFixMessage()).append("\n");
                }
            }
            if (config.withInfo && check.hasInfo()) {
                sb.append("\u3010\u8bf7\u624b\u52a8\u68c0\u67e5\u3011\u3010").append(testName).append("\u3011 ").append(check.getInfoMessage()).append("\n");
            }
            if (!config.withLog || !config.withLogOnSuccess && !this.hasError || !check.hasLog()) continue;
            sb.append("\u3010log\u3011:" + check.getLogMessage()).append("\n");
        }
        if (!this.hasError) {
            sb.append("\u96c6\u6210\u81ea\u52a8\u6392\u67e5\u5de5\u5177\uff1a \u606d\u559c\u6ca1\u6709\u68c0\u6d4b\u5230\u4efb\u4f55\u95ee\u9898\n");
        }
        return sb.toString();
    }

    public void clear() {
        this.checks.clear();
        this.hasError = false;
    }

    private AutoCheck(Context context) {
        AutoCheck.context = context;
        this.checks = new LinkedHashMap();
    }

    private static abstract class Check {
        protected String errorMessage = null;
        protected String fixMessage = null;
        protected String infoMessage = null;
        protected StringBuilder logMessage = new StringBuilder();

        public abstract void check();

        public boolean hasError() {
            return this.errorMessage != null;
        }

        public boolean hasFix() {
            return this.fixMessage != null;
        }

        public boolean hasInfo() {
            return this.infoMessage != null;
        }

        public boolean hasLog() {
            return !this.logMessage.toString().isEmpty();
        }

        public void appendLogMessage(String message) {
            this.logMessage.append(message + "\n");
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public String getFixMessage() {
            return this.fixMessage;
        }

        public String getInfoMessage() {
            return this.infoMessage;
        }

        public String getLogMessage() {
            return this.logMessage.toString();
        }
    }

    private static class AppInfoCheck
    extends Check {
        private String appId;
        private String appKey;
        private String secretKey;

        public AppInfoCheck(String appId, String appKey, String secretKey) {
            this.appId = appId;
            this.appKey = appKey;
            this.secretKey = secretKey;
        }

        @Override
        public void check() {
            this.appendLogMessage("try to check appId " + this.appId + " ,appKey=" + this.appKey + " ,secretKey" + this.secretKey);
            if (this.appId == null || this.appId.isEmpty()) {
                this.errorMessage = "appId \u4e3a\u7a7a";
                this.fixMessage = "\u586b\u5199appID";
            } else if (this.appKey == null || this.appKey.isEmpty()) {
                this.errorMessage = "appKey \u4e3a\u7a7a";
                this.fixMessage = "\u586b\u5199appID";
            } else if (this.secretKey == null || this.secretKey.isEmpty()) {
                this.errorMessage = "secretKey \u4e3a\u7a7a";
                this.fixMessage = "secretKey";
            }
            try {
                this.checkOnline();
            }
            catch (UnknownHostException e) {
                this.infoMessage = "\u65e0\u7f51\u7edc\u6216\u8005\u7f51\u7edc\u4e0d\u8fde\u901a\uff0c\u5ffd\u7565\u68c0\u6d4b : " + e.getMessage();
            }
            catch (Exception e) {
                this.errorMessage = e.getClass().getCanonicalName() + ":" + e.getMessage();
                this.fixMessage = " \u91cd\u65b0\u68c0\u6d4bappId\uff0c appKey\uff0c appSecret\u662f\u5426\u6b63\u786e";
            }
        }

        public void checkOnline() throws Exception {
            String urlpath = "https://openapi.baidu.com/oauth/2.0/token?grant_type=client_credentials&client_id=" + this.appKey + "&client_secret=" + this.secretKey;
            URL url = new URL(urlpath);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(1000);
            InputStream is = conn.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            StringBuilder result = new StringBuilder();
            String line = "";
            do {
                if ((line = reader.readLine()) == null) continue;
                result.append(line);
            } while (line != null);
            String res = result.toString();
            this.appendLogMessage("openapi return " + res);
            JSONObject jsonObject = new JSONObject(res);
            String error = jsonObject.optString("error");
            if (error != null && !error.isEmpty()) {
                throw new Exception("appkey secretKey \u9519\u8bef, error:" + error + ", json is" + result);
            }
            String token = jsonObject.getString("access_token");
            if (token == null || !token.endsWith("-" + this.appId)) {
                throw new Exception("appId \u4e0e appkey\u53ca appSecret \u4e0d\u4e00\u81f4\u3002appId = " + this.appId + " ,token = " + token);
            }
        }
    }

    private static class ApplicationIdCheck
    extends Check {
        private String appId;
        private Context context;

        public ApplicationIdCheck(Context context, String appId) {
            this.appId = appId;
            this.context = context;
        }

        @Override
        public void check() {
            this.infoMessage = "\u5982\u679c\u60a8\u96c6\u6210\u8fc7\u7a0b\u4e2d\u9047\u89c1\u79bb\u7ebf\u5408\u6210\u521d\u59cb\u5316\u95ee\u9898\uff0c\u8bf7\u68c0\u67e5\u7f51\u9875\u4e0aappId\uff1a" + this.appId + " \u5e94\u7528\u662f\u5426\u5f00\u901a\u4e86\u5408\u6210\u670d\u52a1\uff0c\u5e76\u4e14\u7f51\u9875\u4e0a\u7684\u5e94\u7528\u586b\u5199\u4e86Android\u5305\u540d\uff1a" + this.getApplicationId();
        }

        private String getApplicationId() {
            return this.context.getPackageName();
        }
    }

    private static class OfflineResourceFileCheck
    extends Check {
        private String filename;

        public OfflineResourceFileCheck(String filename) {
            this.filename = filename;
        }

        @Override
        public void check() {
            File file = new File(this.filename);
            if (!file.exists()) {
                this.errorMessage = "\u8d44\u6e90\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a" + this.filename;
            } else if (!file.canRead()) {
                this.errorMessage = "\u8d44\u6e90\u6587\u4ef6\u4e0d\u53ef\u8bfb\uff1a" + this.filename;
            } else if (!SynthesizerTool.verifyModelFile((String)this.filename)) {
                this.errorMessage = "SDK verifyModelFile\u65b9\u6cd5\u5224\u65ad\u6a21\u578b\u6587\u4ef6\u4e0d\u662f\u6709\u6548\u7684\uff0c\u8bf7\u91cd\u65b0\u590d\u5236\uff1a" + this.filename;
            }
            if (this.hasError()) {
                this.fixMessage = "\u8bf7\u5c06demo\u4e2dsrc/main/assets\u76ee\u5f55\u4e0b\u540c\u540d\u6587\u4ef6\u590d\u5236\u5230 " + this.filename;
            }
        }
    }

    private static class ParamKeyExistCheck
    extends Check {
        private Map<String, String> params;
        private String key;
        private String prefixErrorMessage;

        public ParamKeyExistCheck(Map<String, String> params, String key, String prefixErrorMessage) {
            this.params = params;
            this.key = key;
            this.prefixErrorMessage = prefixErrorMessage;
        }

        @Override
        public void check() {
            if (this.params == null || !this.params.containsKey(this.key)) {
                this.errorMessage = this.prefixErrorMessage + " \u53c2\u6570\u4e2d\u6ca1\u6709\u8bbe\u7f6e\uff1a" + this.key;
                this.fixMessage = "\u8bf7\u53c2\u7167demo\u5728\u8bbe\u7f6e " + this.key + "\u53c2\u6570";
            }
        }
    }

    private static class JniCheck
    extends Check {
        private Context context;
        private String[] soNames;

        public JniCheck(Context context, boolean isOnlineSdk) {
            this.context = context;
            this.soNames = isOnlineSdk ? new String[]{"libBDSpeechDecoder_V1.so"} : new String[]{"libbd_etts.so", "libBDSpeechDecoder_V1.so", "libgnustl_shared.so"};
        }

        @Override
        public void check() {
            String path = this.context.getApplicationInfo().nativeLibraryDir;
            this.appendLogMessage("Jni so\u6587\u4ef6\u76ee\u5f55 " + path);
            File[] files = new File(path).listFiles();
            TreeSet<String> set = new TreeSet<String>();
            if (files != null) {
                for (File file : files) {
                    if (!file.canRead()) continue;
                    set.add(file.getName());
                }
            }
            this.appendLogMessage("Jni\u76ee\u5f55\u5185\u6587\u4ef6: " + set.toString());
            for (String name : this.soNames) {
                if (set.contains(name)) continue;
                this.errorMessage = "Jni\u76ee\u5f55" + path + " \u7f3a\u5c11\u53ef\u8bfb\u7684so\u6587\u4ef6\uff1a" + (String)name + "\uff0c \u8be5\u76ee\u5f55\u6587\u4ef6\u5217\u8868: " + set.toString();
                this.fixMessage = "\u5982\u679c\u60a8\u7684app\u5185\u6ca1\u6709\u5176\u5b83so\u6587\u4ef6\uff0c\u8bf7\u590d\u5236demo\u91cc\u7684src/main/jniLibs\u81f3\u540c\u540d\u76ee\u5f55\u3002 \u5982\u679capp\u5185\u6709so\u6587\u4ef6\uff0c\u8bf7\u5408\u5e76\u76ee\u5f55\u653e\u4e00\u8d77(\u6ce8\u610f\u76ee\u5f55\u53d6\u4ea4\u96c6\uff0c\u591a\u4f59\u7684\u76ee\u5f55\u5220\u9664)\u3002";
                break;
            }
        }
    }

    private static class PermissionCheck
    extends Check {
        private Context context;

        public PermissionCheck(Context context) {
            this.context = context;
        }

        @Override
        public void check() {
            String[] permissions = new String[]{"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE", "android.permission.MODIFY_AUDIO_SETTINGS", "android.permission.ACCESS_WIFI_STATE"};
            ArrayList<String> toApplyList = new ArrayList<String>();
            for (String perm : permissions) {
                if (0 == ContextCompat.checkSelfPermission((Context)this.context, (String)perm)) continue;
                toApplyList.add(perm);
            }
            if (!toApplyList.isEmpty()) {
                this.errorMessage = "\u7f3a\u5c11\u6743\u9650\uff1a" + toApplyList;
                this.fixMessage = "\u8bf7\u4eceAndroidManifest.xml\u590d\u5236\u76f8\u5173\u6743\u9650";
            }
        }
    }

    private static class PrintConfig {
        public boolean withFix = true;
        public boolean withInfo = false;
        public boolean withLog = false;
        public boolean withLogOnSuccess = false;

        private PrintConfig() {
        }
    }
}

