/*
 * Decompiled with CFR 0.152.
 */
package uni.mt.tts;

import android.content.Context;
import android.widget.Toast;
import com.alibaba.fastjson.JSONObject;
import com.baidu.tts.auth.AuthInfo;
import com.baidu.tts.client.SpeechError;
import com.baidu.tts.client.SpeechSynthesizer;
import com.baidu.tts.client.SpeechSynthesizerListener;
import com.baidu.tts.client.TtsMode;
import com.taobao.weex.bridge.JSCallback;
import io.dcloud.feature.uniapp.annotation.UniJSMethod;
import io.dcloud.feature.uniapp.bridge.UniJSCallback;
import io.dcloud.feature.uniapp.common.UniModule;
import io.dcloud.feature.uniapp.utils.UniLogUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import uni.mt.tts.control.InitTTSConfig;
import uni.mt.tts.util.IOfflineResourceConst;
import uni.mt.tts.util.OfflineResource;

public class BaiduTTS
extends UniModule
implements IOfflineResourceConst {
    public Boolean isReady = false;
    private static final String TAG = "BaiduTTS";
    protected SpeechSynthesizer mSpeechSynthesizer;
    protected String offlineVoice = "F";
    protected String appId;
    protected String appKey;
    protected String secretKey;
    protected String sn;
    private TtsMode ttsMode = TtsMode.OFFLINE;
    private UniJSCallback initCallback;
    private JSCallback onStartCallback = new JSCallback(){

        public void invoke(Object o) {
        }

        public void invokeAndKeepAlive(Object o) {
        }
    };
    private JSCallback onDoneCallback = new JSCallback(){

        public void invoke(Object o) {
        }

        public void invokeAndKeepAlive(Object o) {
        }
    };
    private JSCallback onErrorCallback = new JSCallback(){

        public void invoke(Object o) {
        }

        public void invokeAndKeepAlive(Object o) {
        }
    };
    SpeechSynthesizerListener speechSynthesizerListener = new SpeechSynthesizerListener(){

        public void onSynthesizeStart(String s) {
        }

        public void onSynthesizeDataArrived(String s, byte[] bytes, int i, int i1) {
        }

        public void onSynthesizeFinish(String s) {
        }

        public void onSpeechStart(String s) {
            BaiduTTS.this.print("speechSynthesizerListener onSpeechStart s=" + s);
            BaiduTTS.this.onStartCallback.invokeAndKeepAlive((Object)s);
        }

        public void onSpeechProgressChanged(String s, int i) {
        }

        public void onSpeechFinish(String s) {
            BaiduTTS.this.print("onSpeechProgressChanged onSpeechFinish s=" + s);
            BaiduTTS.this.onDoneCallback.invokeAndKeepAlive((Object)s);
        }

        public void onError(String s, SpeechError speechError) {
            BaiduTTS.this.print("onSpeechProgressChanged onError s=" + s + " error=" + speechError.toString());
            BaiduTTS.this.onErrorCallback.invokeAndKeepAlive((Object)s);
        }
    };

    @UniJSMethod(uiThread=true)
    public void onStart(JSCallback jsCallback) {
        this.onStartCallback = jsCallback;
    }

    @UniJSMethod(uiThread=true)
    public void onDone(JSCallback jsCallback) {
        this.onDoneCallback = jsCallback;
    }

    @UniJSMethod(uiThread=true)
    public void onError(JSCallback jsCallback) {
        this.onErrorCallback = jsCallback;
    }

    @UniJSMethod(uiThread=true)
    public void toast(String text) {
        Toast.makeText((Context)this.mUniSDKInstance.getContext(), (CharSequence)text, (int)0).show();
    }

    @UniJSMethod(uiThread=true)
    public void init(JSONObject object, UniJSCallback callback) {
        this.initCallback = callback;
        this.appId = this.GetValue(object, "appId", "");
        this.appKey = this.GetValue(object, "appKey", "");
        this.secretKey = this.GetValue(object, "secretKey", "");
        this.sn = this.GetValue(object, "sn", "");
        this.print("appKey: " + this.appKey);
        this.print("secretKey: " + this.secretKey);
        this.print("appId: " + this.appId);
        this.print("sn: " + this.sn);
        InitTTSConfig config = this.getInitConfig(this.speechSynthesizerListener);
        this.mSpeechSynthesizer = SpeechSynthesizer.getInstance();
        this.mSpeechSynthesizer.setContext(this.mUniSDKInstance.getContext());
        this.mSpeechSynthesizer.setAppId(config.getAppId());
        this.mSpeechSynthesizer.setApiKey(config.getAppKey(), config.getSecretKey());
        this.mSpeechSynthesizer.setParam(SpeechSynthesizer.PARAM_AUTH_SN, config.getSn());
        this.setParams(this.getParams());
        this.mSpeechSynthesizer.setSpeechSynthesizerListener(config.getListener());
        int result = this.mSpeechSynthesizer.initTts(config.getTtsMode());
        this.isReady = result == 0;
        this.print("TTS init = " + result);
        this.initCallback.invoke((Object)result);
    }

    @UniJSMethod(uiThread=false)
    public int speak(String text, String utteranceId) {
        if (!this.isReady.booleanValue()) {
            this.print("[ERROR], \u8bf7\u5148\u521d\u59cb\u5316\u5f15\u64ce");
            return -1;
        }
        int result = this.mSpeechSynthesizer.speak(text, utteranceId);
        this.print("\u5408\u6210\u5e76\u64ad\u653e");
        this.checkResult(result, "speak");
        return result;
    }

    @UniJSMethod(uiThread=false)
    public void setSpeed(int v) {
        this.mSpeechSynthesizer.setParam(SpeechSynthesizer.PARAM_SPEED, Integer.toString(v));
    }

    @UniJSMethod(uiThread=false)
    public void setVolumn(int v) {
        this.mSpeechSynthesizer.setParam(SpeechSynthesizer.PARAM_VOLUME, Integer.toString(v));
    }

    @UniJSMethod(uiThread=false)
    public void setPitch(int v) {
        this.mSpeechSynthesizer.setParam(SpeechSynthesizer.PARAM_PITCH, Integer.toString(v));
    }

    public boolean checkAuth() {
        AuthInfo authInfo = this.mSpeechSynthesizer.auth(this.ttsMode);
        if (!authInfo.isSuccess()) {
            String errorMsg = authInfo.getTtsError().getDetailMessage();
            this.print("\u672a\u6388\u6743\uff1a" + errorMsg);
            return false;
        }
        return true;
    }

    @UniJSMethod(uiThread=false)
    public void pause() {
        int result = this.mSpeechSynthesizer.pause();
        this.checkResult(result, "pause");
    }

    @UniJSMethod(uiThread=false)
    public void resume() {
        int result = this.mSpeechSynthesizer.resume();
        this.checkResult(result, "resume");
    }

    @UniJSMethod(uiThread=false)
    public void stop() {
        this.print("\u505c\u6b62\u5408\u6210\u5f15\u64ce");
        this.mSpeechSynthesizer.stop();
    }

    @UniJSMethod(uiThread=false)
    public void destroy() {
        if (this.mSpeechSynthesizer == null) {
            return;
        }
        this.mSpeechSynthesizer.stop();
        this.mSpeechSynthesizer.release();
        this.mSpeechSynthesizer = null;
        this.isReady = false;
        this.print("\u91ca\u653e\u8d44\u6e90\u6210\u529f");
    }

    @UniJSMethod(uiThread=false)
    public int changeSpeeker(String mode) {
        this.offlineVoice = mode;
        OfflineResource offlineResource = this.createOfflineResource(this.offlineVoice);
        this.print("\u5207\u6362\u79bb\u7ebf\u8bed\u97f3\uff1a" + offlineResource.getModelFilename());
        int result = this.mSpeechSynthesizer.loadModel(offlineResource.getModelFilename(), offlineResource.getTextFilename());
        this.checkResult(result, "changeSpeeker");
        return result;
    }

    protected InitTTSConfig getInitConfig(SpeechSynthesizerListener listener) {
        Map<String, String> params = this.getParams();
        InitTTSConfig initTTSConfig = new InitTTSConfig(this.appId, this.appKey, this.secretKey, this.sn, this.ttsMode, params, listener);
        return initTTSConfig;
    }

    public void setParams(Map<String, String> params) {
        if (params != null) {
            for (Map.Entry<String, String> e : params.entrySet()) {
                this.mSpeechSynthesizer.setParam(e.getKey(), e.getValue());
            }
        }
    }

    protected Map<String, String> getParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        OfflineResource offlineResource = this.createOfflineResource(this.offlineVoice);
        params.put(SpeechSynthesizer.PARAM_TTS_TEXT_MODEL_FILE, offlineResource.getTextFilename());
        params.put(SpeechSynthesizer.PARAM_TTS_SPEECH_MODEL_FILE, offlineResource.getModelFilename());
        params.put(SpeechSynthesizer.PARAM_MIX_MODE, SpeechSynthesizer.MIX_MODE_HIGH_SPEED_SYNTHESIZE_WIFI);
        params.put(SpeechSynthesizer.PARAM_SPEED, "5");
        params.put(SpeechSynthesizer.PARAM_PITCH, "5");
        params.put(SpeechSynthesizer.PARAM_VOLUME, "15");
        return params;
    }

    private void print(String message) {
        UniLogUtils.i((String)TAG, (String)message);
    }

    private void checkResult(int result, String method) {
        if (result != 0) {
            this.print("error code :" + result + " method:" + method);
        }
    }

    protected OfflineResource createOfflineResource(String voiceType) {
        OfflineResource offlineResource = null;
        try {
            offlineResource = new OfflineResource(this.mUniSDKInstance.getContext(), voiceType);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.print("\u3010error\u3011:copy files from assets failed." + e.getMessage());
        }
        return offlineResource;
    }

    private int GetValue(JSONObject object, String key, int defaultValue) {
        object = object == null ? new JSONObject() : object;
        return object.containsKey((Object)key) ? object.getInteger(key) : defaultValue;
    }

    private String GetValue(JSONObject object, String key, String defaultValue) {
        object = object == null ? new JSONObject() : object;
        return object.containsKey((Object)key) ? object.getString(key) : defaultValue;
    }

    private Boolean GetValue(JSONObject object, String key, Boolean defaultValue) {
        object = object == null ? new JSONObject() : object;
        return object.containsKey((Object)key) ? object.getBoolean(key) : defaultValue;
    }
}

